state ForestWitchSpells in W3MagicVigil
{
	var damage_action			 						: W3DamageAction;
	var damage_value									: float;
	var actors 											: array<CActor>;
	var i												: int;
	var main_effect, effect_entity  					: CEntity;
	var target											: CActor; 
	var entities 										: array<CGameplayEntity>; 
	var position 										: Vector;
	var rotation 										: EulerAngles;
	var slotMatrix 										: Matrix;
	var permafrost_trap   								: W3PermafrostTrap;
	var ents_destroy									: array< CEntity >;
	var duration										: float;
	var CustomEffect									: SCustomEffectParams;
	var castDir											: Vector;
	var targetPosition									: Vector;
	var icespear										: W3PermafrostSpear;
	var dummy											: CEntity;
	var dummy_proj                                      : W3PermafrostDummy;
	var vector_attach 									: Vector;
	var proj 											: W3IceentityBolt;
	
	event OnEnterState( prevStateName : name )
	{
		if ( !theSound.SoundIsBankLoaded("magic_yennefer.bnk") )
		{
			theSound.SoundLoadBank( "magic_yennefer.bnk", false );
		}
	
		if ( parent.act_signtype == ST_Axii )
		{
			if ( parent.actor && parent.actor.IsAlive() )
			{
				thePlayer.SetSlideTarget( parent.actor );
			}
			else
			{
				thePlayer.AddCustomOrientationTarget( OT_CameraOffset, 'MagicSpells' );
			}
		}
		else
		if ( !theGame.GetInGameConfigWrapper().GetVarValue('magic_spells_main', 'cast_to_camera') )
		{
			if ( !GetMagicVigil().IsAlt() )
			{
				if ( parent.actor && parent.actor.IsAlive() )
				{
					thePlayer.SetSlideTarget( parent.actor );
				}
				else
				{
					thePlayer.AddCustomOrientationTarget( OT_CameraOffset, 'MagicSpells' );
				}
			}
		}
		else
		{
			thePlayer.AddCustomOrientationTarget( OT_CameraOffset, 'MagicSpells' );
		}
		
		panther_witch_precast();
	}
	
	event OnCastSpellAnimation( animEventName : name, animEventType : EAnimationEventType, animInfo : SAnimationEventAnimInfo )
	{
		if ( animEventName == 'cast_begin' )
		{	
		}
		else if ( animEventName == 'cast_throw' )
		{
			cast_spells_witch();
			thePlayer.RemoveCustomOrientationTarget( 'MagicSpells' );
		}
		else if ( animEventName == 'cast_end' )
		{
			cast_spells_axii_witch();
			//parent.GotoState( 'Vigil_Dreaming' );
		}
	}
	
	private entry function panther_witch_precast()
	{
		var portal				: CEntity;
		var newPos				: Vector;
		
		if ( parent.spell_name == 'black_panther' )
		{
			position = thePlayer.GetWorldPosition() + thePlayer.GetWorldForward() * 2.5;
			position = find_position_spells( position );	
			if( !theGame.GetWorld().NavigationFindSafeSpot( position, 1, 1, newPos ) )
			{
				theGame.GetGuiManager().ShowNotification( GetLocStringByKeyExt( "menu_cannot_perform_action_here" ),, true );
				parent.GotoState( 'Vigil_Dreaming' );
			}
			else
			{
				Sleep(0.3);
				//position.Z += 2;
				
				portal = theGame.CreateEntity( (CEntityTemplate)LoadResource( "dlc\magicspellsrev\data\entities\portal_for_golems.w2ent", true ), position );
				portal.PlayEffect('teleport');
				portal.StopAllEffects();
				portal.DestroyAfter( 1.5 );
			}
		}
	}
	
	private function cast_spells_witch()
	{
		var golem_npc 			: CNewNPC;
		var bonusAbilityName	: name;
		var roots				: CEntity;
	
		switch( parent.spell_name )
		{
			case 'black_panther':
				{
					parent.destroy_panthers();
					
					duration = 15;
					duration += duration * ( GetMagicVigil().get_magic_spellpower() * 0.5 );
					
					//position.Z -= 1;
					
					main_effect = theGame.CreateEntity( (CEntityTemplate)LoadResource( 'panther' ), position, thePlayer.GetWorldRotation() );
					main_effect.AddTag( 'spells_panther' );
					golem_npc = (CNewNPC)main_effect;
					golem_npc.AddTag( 'spells_panther_npc' );
					golem_npc.SetAttitude( thePlayer, AIA_Friendly );
					
					bonusAbilityName = thePlayer.GetSkillAbilityName(S_Magic_s05);
					for(i=0; i<=3; i+=1)
					{
						golem_npc.AddAbility(bonusAbilityName, true);
					}
					parent.AddTimer( 'destroy_summoned_panther', duration );
					parent.AddTimer( 'evaluate_targets_for_panther', 0.3, true);
					
					Spells_drain_stamina( parent.stamina_cost, parent.stamina_delay, parent.signskill );
					
					parent.GotoState( 'Vigil_Dreaming' );
				}

				break;
			case 'rootstrain':
				{
					thePlayer.CalcEntitySlotMatrix('l_weapon', slotMatrix);
					position = MatrixGetTranslation(slotMatrix);
					rotation = thePlayer.GetWorldRotation();
				
					castDir 		= MatrixGetAxisX( slotMatrix );
					castDir.Z 		= ClampF( castDir.Z, 0, 10 );
					targetPosition 	= position + ( 5 * castDir );
						
					parent.hand_aim_position = position;
					parent.hand_aim_direction = castDir;
						
					//rotation.Yaw += 90;
					
					parent.templatename = "dlc\magicspellsrev\data\entities\forest_witch_cone.w2ent";
					
					main_effect = (CEntity)theGame.CreateEntity( (CEntityTemplate)LoadResource( parent.templatename ,true ), position, rotation );
					main_effect.PlayEffect('cone_lv3'); 
					main_effect.DestroyAfter(10);
					
					actors = thePlayer.GetNPCsAndPlayersInCone( 9, VecHeading( castDir ), 60, 100, , FLAG_Attitude_Hostile + FLAG_OnlyAliveActors);
					for (i=0; i<actors.Size(); i+=1)	
					{
						CustomEffect.effectType = EET_Rootstrain;
						CustomEffect.creator = thePlayer;
						CustomEffect.sourceName = thePlayer.GetName();
						CustomEffect.duration = GetMagicVigil().get_magic_spellpower() * 5;
						actors[i].AddEffectCustom(CustomEffect);
						
						//theGame.witcherLog.AddMessage("duration " + (string)( GetMagicVigil().get_magic_spellpower() * 5 ) );
					}
				
					thePlayer.SoundEvent("magic_yennefer_q310_spell_03");
		
					Spells_drain_stamina( parent.stamina_cost, parent.stamina_delay, parent.signskill );
					
					parent.GotoState( 'Vigil_Dreaming' );
				}
				
				break;
			default:		
				break;
		}
		
	}
	
	private function cast_spells_axii_witch()
	{
		var root 			: W3WitchRoot;
	
		if ( parent.spell_name == 'witch_root' )
		{
			if ( parent.actor && parent.actor.GetDistanceFromGround( 2 ) < 1.5f && parent.actor.IsAlive() && IsRequiredAttitudeBetween(thePlayer, parent.actor, true, false, false) )
			{
				thePlayer.SoundEvent("magic_yennefer_q310_spell_01");
			
				targetPosition = TraceFloor( parent.actor.GetWorldPosition() );
			
				parent.templatename = "dlc\magicspellsrev\data\entities\forest_witch_root.w2ent";
				
				root = (W3WitchRoot)theGame.CreateEntity( (CEntityTemplate)LoadResource( parent.templatename, true ), targetPosition );
				root.DestroyAfter(10);
				
				Spells_drain_stamina( parent.stamina_cost, parent.stamina_delay, parent.signskill );
				
				thePlayer.SetCombatIdleStance( 1.f );
			}
			parent.GotoState( 'Vigil_Dreaming' );
		}
	}
	
	event OnLeaveState( nextStateName : name )
	{
	}
}